/*----------------------------------------------------------------------------
 * Name:    LCM.h
 * Purpose: LCM definitions
 * Note(s):
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#ifndef __LCM_H
#define __LCM_H

#include	<string.h>
#include	<stdarg.h>
#include	"ht32f5xxxx_01.h"
#include	"timer.h"
#define  _LCM_RES_   10     /* PB10 */	
#define  _LCM_RS_    11     /* PB11 */
#define  _LCM_NCS_   9     /* PB9 */
#define  _LCM_SCK_   0     /* PA0 */
#define  _LCM_SDA_   1     /* PA1 */

#define	LCM_NCS_LOW    HT_GPIOB->DOUTR &= ~(1UL << _LCM_NCS_);		// NCS = 0											
#define	LCM_NCS_HIGH   HT_GPIOB->DOUTR |= (1UL << _LCM_NCS_);			// NCS = 1
#define	LCM_RES_LOW    HT_GPIOB->DOUTR &= ~(1UL << _LCM_RES_);		// RES = 0											
#define	LCM_RES_HIGH   HT_GPIOB->DOUTR |= (1UL << _LCM_RES_);			// RES = 1
#define	LCM_RS_LOW	   HT_GPIOB->DOUTR &= ~(1UL << _LCM_RS_);   	// LCM_RS = 0
#define	LCM_RS_HIGH	   HT_GPIOB->DOUTR |= (1UL << _LCM_RS_);    	// LCM_RS = 1

#define LCM_SPI     	HT_SPI1																														
#define	LCM_SPI_SPEED	(5000000UL)

enum 
{
	LCM_FONT6X8 = 0x01,
	LCM_FONT8X8,
	LCM_FONT8X16
};

enum 
{
   DSP_NORMAL = 0x50,
   DSP_INVERT,
   DSP_CURSOR,
   DSP_CLEAR	
};

enum
{
	DSP_DIGIT,
	DSP_STRING,
	DSP_DIGIT_AND_STRING,
};

extern uc8 BestComm_Logo[];

void lcm_bus_configure(void);
void lcm_configure(void);
void lcm_write_cmd(u8 cmdx);
void lcm_write_data(u8 da);
void lcm_set_position(u8 row,u8 col);
void lcm_write_blcok_data(u8 leng,u8 *p,u8 invt);
void lcm_clear(void);
void lcm_put_map(u8 *p);
void lcm_printf(u8 row,u8 col,u8 invt,u8 font,const char *format,...);
void lcm_put6x8_char(char val,u8 row,u8 col,u8 invt);
void lcm_put8x8_char(char val,u8 row,u8 col,u8 invt);
void lcm_put8x16_char(char val,u8 row,u8 col,u8 invt);
void lcm_put6x8_clearing(u8 row,u8 col);
void lcm_put6x8_string(sc8 *p,u8 row,u8 col,u8 invt);
void lcm_put8x8_clearing(u8 row);
void lcm_put8x8_string(sc8 *p,u8 row,u8 col,u8 invt);
void lcm_put8x16_clearing(u8 row);
void lcm_put8x16_string(sc8 *p,u8 row,u8 col,u8 invt);
void LCM_initial(void);
void LCM_disconnected(void);
void LCM_displaymsg(void);
void show_message(u8 *row,u8 len, u8 *str, u8 attr);
void clear_message(void);

#endif
